 ; Ŀ
 ;   Bomex - extract bom numbers and counts to a csv file.                 
 ;   Also counts block and xref subentity bom blocks.                      
 ;   If the csv file Bom.csv exists in the current directory then the      
 ;   bom numbers from the current drawing will be added to it.             
 ;   Copyright 2005, 2007, 2008 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Bomp - count BOM tag numbers.                                         
 ;   Arguments: Elist, a list of bom block enames.                         
 ;              Lista, a list of bom block enames not to mark.  All of     
 ;                     these will also be in Elist.                        
 ;   Calls Croco, Horiz, and Lowest.                                       
 ;   Returns a list of Bom tag item numbers and quantities.                
 ; 
 (DEFUN BOMP (elist lista / num enam bomnum typl typr quant isstr sub subnum
                                                        strsub gnusub malist)
 ; Ŀ
 ;   Step through the selection set, count each type.                      
 ; 
  (setq num 0)
  (while (and elist (setq enam (nth num elist)))
         (if (not (member enam lista))
             (croco (cdr (assoc 10 (entget enam))) 140 170))
         (setq num (1+ num))
         (setq bomnum (cdr (assoc 1 (entget (setq enam (entnext enam))))))
         (setq typl (cdr (assoc 1 (entget (setq enam (entnext enam))))))
         (setq typr (cdr (assoc 1 (entget (setq enam (entnext enam))))))
 ; Ŀ
 ;   Find which attribute contains the quantity, save it.                  
 ;   This is a bit kludgy.  Actually very.                                 
 ; 
         (setq quant ())
         (if (and (not (member typl '("" " " "  " "-" "..." "_")))
                  (not (= (substr typl 1 4) "NOTE")))
             (setq quant typl))
         (if (and (not (member typr '("" " " "  " "-" "..." "_")))
                  (not (= (substr typr 1 4) "NOTE")))
             (setq quant typr))
 ; Ŀ
 ;   Extract the number from the variable.                                 
 ; 
         (cond ((null quant)
                (setq quant 1))
               ((or (= (type (read quant)) 'INT)
                    (= (type (read quant)) 'REAL))
                (setq quant (read quant)))
               ((or (= (strcase (substr quant 1 3) t) "typ")
                    (and (= (strcase (substr quant 1 1) t) "a")
                         (= (strcase (substr quant 3 3) t) "r")))
                (setq quant "A/R"))
               ((= (strcase (substr quant 1 1) t) "x")
                (setq quant (read (substr quant 2))))
               ((= (strcase (substr quant (strlen quant)) t) "x")
                (setq quant (read (substr quant 1 (1- (strlen quant))))))
               (T (setq quant 1)))
 ; Ŀ
 ;   See if the Quant variable contains a string or a number.              
 ; 
         (if (= (type quant) 'STR)
             (setq isstr t)
             (setq isstr ()))
 ; Ŀ
 ;   Add the number tag or the tag and number to the master list.          
 ;   See if the second atom in the list is a string.                       
 ; 
         (setq sub (assoc bomnum malist))
         (setq subnum (cadr sub))
         (if (= (type subnum) 'STR)
             (setq strsub t)
             (setq strsub ()))
 ; Ŀ
 ;   Cond: the main number attribute was empty - ignore the block.         
 ; 
         (cond ((member bomnum '("" " " "  " "-" "..." "_" "X" "XX")))
 ; Ŀ
 ;   Cond: there is a sublist matching the Bom No. and (quant is a string  
 ;   or subnum is a string.)                                               
 ; 
               ((and sub (or isstr strsub))
                (setq gnusub (list (car sub) "A/R"))
                (setq malist (subst gnusub sub malist)))
 ; Ŀ
 ;   Cond: there is a sublist matching the Bom No. and Quant is a number   
 ;   and subnum is a number.                                               
 ; 
               ((and sub (null isstr) (null strsub))
                (setq gnusub (list (car sub) (+ subnum quant)))
                (setq malist (subst gnusub sub malist)))
 ; Ŀ
 ;   Cond: there is no matching sublist.                                   
 ; 
               ((null sub)
                (setq gnusub (list bomnum quant))
                (setq malist (cons gnusub malist)))))
 ; Ŀ
 ;   Malist should now contain all the bom data.                           
 ; 
  (setq malist (horiz malist))
 malist)
 ; Ŀ
 ;   Bomp end.                                                             
 ; 

 ; Ŀ
 ;   Bullax - write a list of lists to a csv file.                         
 ;   Very hacky, needs a proper list to string converter.                  
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BULLAX (lista filnam / fn sub nxtstr nxnx str)
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (setq nxtstr (car sub))
         (setq nxnx (cadr sub))
         (cond ((= (type nxtstr) 'INT)
                (setq nxtstr (itoa nxtstr)))
               ((= (type nxtstr) 'REAL)
                (setq nxtstr (rtos nxtstr))))
         (cond ((= (type nxnx) 'INT)
                (setq nxnx (itoa nxnx)))
               ((= (type nxnx) 'REAL)
                (setq nxnx (rtos nxnx))))
         (setq str (strcat nxtstr "," nxnx))
         (write-line str fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Bullax end.                                                           
 ; 

 ; Ŀ
 ;   Cdfout - suck a cdf file into a list.                                 
 ;   Arguments: filnam, a filename.                                        
 ;   Calls Csplit.                                                         
 ;   Returns a list of lists of strings.                                   
 ; 
 (DEFUN CDFOUT (filnam / fn linn llist malist num gnulis suba)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (if (/= linn "")
                      (progn
                           (setq llist (csplit linn))
 ; Ŀ
 ;   Capitalize the list (i.e. all substrings.)                            
 ; 
                           (setq num 0)
                           (setq gnulis ())
                           (while (setq suba (nth num llist))
                                  (setq suba (strcase suba))
                                  (setq num (1+ num))
                                  (setq gnulis (cons suba gnulis)))
                           (setq gnulis (reverse gnulis))
 ; Ŀ
 ;   If the first element (the pile name) isn't a number then replace it   
 ;   with "0" so that encountering something non-numerical won't crash     
 ;   horiz.  This is not an ideal solution.                                
 ; 
                           (if (/= (type (read (car gnulis))) 'INT)
                               (progn
                                    (setq gnulis (cons "0" (cdr gnulis)))
                                    (prompt "\n* Non-numerical pile name in existing data file replaced with 0.")))
                           (setq malist (append malist (list gnulis))))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Cdfout end.                                                           
 ; 

 ; Ŀ
 ;   Combix - combine lists of lists, taking the first element to be a     
 ;   name and the second to be an amount.  If the second element isn't     
 ;   a number then it replaces the existing second element.                
 ;   This is so that adding 2 to "Typ." gives "Typ." and not 2, since      
 ;   "Typ." may stand for any number from zero up.                         
 ;   Arguments: Lista, a data list.                                        
 ;              Listb, anothr data list.                                   
 ;   Calls nothing, returns a combined data list.                          
 ; 
 (DEFUN COMBIX (lista listb / num asub bsub caras numa numb gnusub)
  (setq num 0)
 ; Ŀ
 ;   Check each sublist from Lista to see if there is a matching sublist   
 ;   (i.e. one with the same leading string) in Listb.                     
 ; 
  (while (setq asub (nth num lista))
         (setq num (1+ num))
 ; Ŀ
 ;   If there is a matching list combine the two.                          
 ; 
         (cond ((setq bsub (assoc (setq caras (car asub)) listb))
                (setq numa (cadr asub))
                (if (and (= (type numa) 'STR)
                         (= (type (read numa)) 'INT))
                    (setq numa (read numa)))
                (setq numb (cadr bsub))
                (if (and (= (type numb) 'STR)
                         (= (type (read numb)) 'INT))
                    (setq numb (read numb)))
                (cond ((and (equal (type numa) 'INT)
                            (equal (type numb) 'INT))
                       (setq gnusub (list caras (+ numa numb))))
                      ((not (equal (type numa) 'INT))
                       (setq gnusub asub))
                      ((not (equal (type numb) 'INT))
                       (setq gnusub bsub)))
 ; Ŀ
 ;   Substitute the new sublist back into Listb.                           
 ; 
                (setq listb (subst gnusub bsub listb)))
 ; Ŀ
 ;   If there is no matching list combine the two.                         
 ; 
               (T (setq listb (cons asub listb)))))
 listb)
 ; Ŀ
 ;   Combix end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Croco - draw a temporary marker.                           
 ;   Arguments: Colo, a colour number.                                     
 ;              Colo2, another colour number.                              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN CROCO (pa colo colo2 / blip rad rad2)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq rad (/ (getvar "viewsize") 35))
  (setq rad2 (/ (getvar "viewsize") 45))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (/ pi 2) rad) (polar pa (* 1.5 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
  (grdraw (polar pa 0 rad) (polar pa pi rad) colo)
  (grdraw (polar pa (/ pi 8) rad2) (polar pa (* 1.125 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.375) rad2) (polar pa (* 1.375 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.625) rad2) (polar pa (* 1.625 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.875) rad2) (polar pa (* 1.875 pi) rad2) colo2)
  (grdraw (polar pa 0 rad2) (polar pa pi rad2) colo2)
  (grdraw (polar pa (/ pi 2) rad2) (polar pa (* 1.5 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.75) (* rad 0.75))
          (polar pa (* pi 1.75) (* rad 0.75)) colo2)
  (grdraw (polar pa (* pi 0.25) (* rad 0.75))
          (polar pa (* pi 1.25) (* rad 0.75)) colo2)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Croco end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Horiz - put a list in order by the first number in each    
 ;   sublist.  Takes one argument, a list, which it returns in order       
 ;   from smallest to largest first element.                               
 ; 
 (DEFUN HORIZ (nexlst / low nxtsub hrzlst newlst orderd)
  (while nexlst
        (setq low (lowest nexlst))                 ; lowest leading number
        (while (and nexlst (setq nxtsub (nth 0 nexlst)))
               (if (equal low (read (car nxtsub)))
                   (setq hrzlst (append hrzlst (list nxtsub)))
                   (setq newlst (append newlst (list nxtsub))))
               (setq nexlst (cdr nexlst)))          ; remove 1st ent from list
        (setq orderd (append orderd hrzlst))        ; add lev sublst to levels
        (setq hrzlst ())                            ; set to () for next loop
        (setq nexlst newlst)                        ; nexlst reconstituted
        (setq newlst ()))                           ; empty new list & reuse
  orderd)
 ; Ŀ
 ;   Horiz end.                                                            
 ; 

 ; Ŀ
 ;   Isxnam: see if a given block is an xref by block name.                
 ;   Argument: Blnam, the block name.                                      
 ;   Returns T: it was an xref, or nil: it wasn't, or no such block is     
 ;   is defined in the drawing.                                            
 ; 
 (DEFUN ISXNAM (blnam / isxrf xp dat)
  (if (setq dat (tblsearch "block" blnam))
      (progn
           (setq xp (cdr (assoc 70 dat)))
           (setq isxrf (logand xp 4))))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxnam end.                                                           
 ; 

 ; Ŀ
 ;   Isxref: see if a given block is an xref.                              
 ;   Arguments: Blnam, either an entity name or a block name string.       
 ;   Returns T if the block was an xref, else nil.                         
 ; 
 (DEFUN ISXREF (blnam / dat xp isxrf)
  (if (= (type blnam) 'ename)
      (setq blnam (cdr (assoc 2 (entget blnam)))))
  (setq dat (tblsearch "block" blnam))
  (setq xp (cdr (assoc 70 dat)))
  (setq isxrf (logand xp 4))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxref end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lowest - find the smallest leading number in a sublist     
 ;   of the list Nexlst which is the sole argument.                        
 ; 
 (DEFUN LOWEST (nexlst / num minlst neth)
  (setq num 0)
  (setq minlst (list min))
  (while (setq neth (nth num nexlst))
         (if neth (setq minlst (append minlst (list (read (car neth))))))
         (setq num (1+ num)))
 (eval minlst))
 ; Ŀ
 ;   Lowest end.                                                           
 ; 

 ; Ŀ
 ;   Pomp - get all blocks whose names are in a list which are             
 ;   subentities of other blocks.                                          
 ;   Takes one argument, a list of block names.                            
 ;   Calls Xnam/(Splat/Sos/Isxnam).                                        
 ;   Returns a list of entity names.                                       
 ; 
 (DEFUN POMP (blist / rew bldata plnam parx pary enam entt blnam pa px py ss
                                               num penam blnams xsc ysc papa)
 ; Ŀ
 ;   While there are blocks in the block tables.                           
 ; 
  (setq rew t)
  (while (setq bldata (tblnext "block" rew))
         (setq rew ())
 ; Ŀ
 ;   Get the parent block name and x and y insertions.                     
 ;   Note that the insertion point of a block definition isn't             
 ;   necessarily 0,0 - it seems to be the point in the drawing which       
 ;   was used as the insertion when the block was made.                    
 ;   This doesn't seem that useful, and offsets for block subentities      
 ;   will have to be adjusted accordingly.                                 
 ; 
         (setq plnam (cdr (assoc 2 bldata)))
         (setq parx (cadr (assoc 10 bldata)))
         (setq pary (caddr (assoc 10 bldata)))
 ; Ŀ
 ;   Get the first subentity name.                                         
 ; 
         (setq enam (cdr (assoc -2 bldata)))
         (while enam
                (setq entt (entget enam))
                (setq blnam (cdr (assoc 2 entt)))
 ; Ŀ
 ;   Get the insertion of the subentity block within the parent.           
 ; 
                (setq pa (cdr (assoc 10 entt)))
                (setq px (car pa))
                (setq py (cadr pa))
 ; Ŀ
 ;   See if the current block is one we are looking for.                   
 ; 
                (if (and blnam
                         (xnam plnam blnam blist)
 ; Ŀ
 ;   If so then see if there are any insertions of the parent block.       
 ; 
                         (setq ss (ssget "x" (list (cons 0 "insert")
                                                   (cons 2 plnam)))))
                    (progn
                         (setq num 0)
                         (while (setq penam (ssname ss num))
                                (setq num (1+ num))
 ; Ŀ
 ;   Must add the subentity ename to the list once per insertion.          
 ; 
                                (setq blnams (cons enam blnams))
 ; Ŀ
 ;   Find the actual location of the subentity block.                      
 ;   Allow for parent block scaling and non-zero base point: multiply      
 ;   offsets px and py by the parent block scaling, add them to the        
 ;   subentity block offsets (from the offset point list papa), do the     
 ;   same with the insertion offsets parx and pary, but subtract rather    
 ;   than add these.                                                       
 ;   Rotation isn't currently supported, but could easily be added.        
 ; 
                                (setq entt (entget penam))
                                (if (null (setq xsc (cdr (assoc 41 entt))))
                                    (setq xsc 1))
                                (if (null (setq ysc (cdr (assoc 42 entt))))
                                    (setq ysc 1))
                                (setq papa (cdr (assoc 10 entt)))
                                (setq pa (list (+ (car papa)
                                                  (* -1 parx xsc)
                                                  (* px xsc))
                                               (+ (cadr papa)
                                                  (* -1 pary ysc)
                                                  (* py ysc))))
 ; Ŀ
 ;   Call Croco to mark the block.                                         
 ; 
                                (croco pa 191 211))))
 ; Ŀ
 ;   Go to the next block subentity.                                       
 ; 
                (setq enam (entnext enam))))
 ; Ŀ
 ;   Return the subentity block name list.                                 
 ; 
 blnams)
 ; Ŀ
 ;   Pomp end.  Sad.                                                       
 ; 

 ; Ŀ
 ;   Pomps - get all blocks of a given name or names which are             
 ;   subentities of other blocks.                                          
 ;   ** This is the previous "Find only" version, which seems likely to    
 ;   worth saving. **                                                      
 ;   Takes one argument, a list of block names.                            
 ;   Calls nothing.                                                        
 ;   Returns a list of entity names.                                       
 ; 
 (DEFUN POMPS (blist / rew bldata enam blnam blnams)
 ; Ŀ
 ;   While there are blocks in the block tables.                           
 ; 
  (setq rew t)
  (while (setq bldata (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 bldata)))
         (setq enam (cdr (assoc -2 bldata)))
         (while enam
                (setq blnam (cdr (assoc 2 (entget enam))))
                (if (member blnam blist)
                    (setq blnams (cons enam blnams)))
                (setq enam (entnext enam))))
 ; Ŀ
 ;   Return the subentity block name list.                                 
 ; 
 blnams)
 ; Ŀ
 ;   Pomps end.                                                            
 ; 

 ; Ŀ
 ;   SOS - return a string split at the substring $n$ (n = any sequence    
 ;   of numerals.)  If the sequence isn't found, returns ().               
 ; 
 (DEFUN SOS (magnus / pos1 pos2 stop found$ cha)
  (setq pos1 1)               ; position of first $
  (setq pos2 1)               ; current position $
  (setq stop ())              ; stop flag
  (setq found$ ())            ; first $ located flag
 ; Ŀ
 ;   While the stop flag isn't set and there is a character at             
 ;   the current position.                                                 
 ; 
  (while (and (null stop)
              (setq cha (substr magnus pos2 1)))
 ; Ŀ
 ;   Cond: if haven't found the first $ yet, do so.                        
 ; 
         (cond ((null found$)
                (while (and (setq cha (substr magnus pos1 1))
                            (/= cha "")
                            (/= cha "$"))
                       (setq pos1 (1+ pos1)))
                (if (= cha "$")
                    (progn
                         (setq found$ T)
                         (setq pos2 (1+ pos1)))
                    (setq stop T)))
 ; Ŀ
 ;   Cond: if have found a second $ then stop.                             
 ; 
               ((and (= cha "$")
                     (> pos2 (1+ pos1)))
                (setq stop "ok"))
 ; Ŀ
 ;   Cond: second $ but without intervening space, so count as first $.    
 ; 
               ((= cha "$")
                (setq pos1 pos2)
                (setq pos2 (1+ pos2)))
 ; Ŀ
 ;   Cond: an integer.  Continue.                                          
 ; 
               ((= (type (read cha)) 'INT)
                (setq pos2 (1+ pos2)))
 ; Ŀ
 ;   Cond: neither an $ nor an integer.  The last $ must not have been     
 ;   the marker, so set Found$ to nil and start looking again.             
 ; 
               (T
                  (setq pos2 (1+ pos2))
                  (setq pos1 pos2)
                  (setq found$ ()))))
 ; Ŀ
 ;   Cond and While end.                                                   
 ;   If the $n$ sequence was found, return everything after it, else ().   
 ; 
  (if (= stop "ok")
      (substr magnus (1+ pos2))))
 ; Ŀ
 ;   Sos end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ;                                                                         
 ;   Completely rewritten 11.19.2000.                                      
 ; 
 (DEFUN SPLAT (sepchr linn / pos len name1 strlst)
  (while (/= (strlen linn) 0)
 ; Ŀ
 ;   Find the first separator character, save everything before it into    
 ;   the Name1 variable, remove it from the start of the string Linn.      
 ; 
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
 ; Ŀ
 ;   Remove spaces from the front and back of Name1.                       
 ; 
         (while (and (> (strlen name1) 0)
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (while (and (> (strlen name1) 0)
                     (= (substr name1 1 1) " "))
                (setq name1 (substr name1 2)))
 ; Ŀ
 ;   Add Name1 to the substring list Strlst.                               
 ; 
         (setq strlst (append strlst (list name1))))
 ; Ŀ
 ;   If the string contained no separator characters then Strlst will be   
 ;   nil, so return a list containing the original string.                 
 ; 
  (if (null strlst) (setq strlst (list linn)))
 strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Wisp - see if an ss is in paper or model space or both.               
 ;   Arguments: Ss, either a selection set or a block name.                
 ;   Returns a list: (("space_name" number) ...)                           
 ; 
 (DEFUN WISP (ss / num enam space sub numa split)
 ; Ŀ
 ;   If ss was a string (i.e. a name rather than an ss) then get an ss     
 ;   of all the inserts of that type in the drawing.                       
 ; 
  (if (= (type ss) 'STR)
      (setq ss (ssget "X" (list (cons 2 ss)))))
 ; Ŀ
 ;   Count the entities in each space.                                     
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq space (cdr (assoc 410 (entget enam))))
         (cond ((setq sub (assoc space split))
                (setq numa (list space (1+ (cadr sub))))
                (setq split (subst numa sub split)))
               (T
                (setq split (cons (list space 1) split)))))
 split)
 ; Ŀ
 ;   Wisp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Xnam - see if a block name - which may be a xref or        
 ;   ex-xref block, with resulting name modifications - is a member of a   
 ;   list.                                                                 
 ;   Arguments: Panam, the parent block name.                              
 ;              Blnam, the block name.                                     
 ;              Blist, the list of block names to match.                   
 ;   Calls Splat, Sos, and Isxnam.                                         
 ;   Returns T if the block name was in the list, or nil.                  
 ; 
 (DEFUN XNAM (panam blnam blist / subnam)
  (if (isxnam panam)
 ; Ŀ
 ;   If the parent block is an xref, split at |.                           
 ; 
      (setq subnam (last (splat "|" blnam)))
 ; Ŀ
 ;   If the parent block is an ex-xref, split at $n$.                      
 ; 
      (if (setq subnam (sos blnam))
          (setq subnam (last subnam))))
 ; Ŀ
 ;   If the block name was split, use that, otherwise use the original.    
 ; 
  (if subnam (setq blnam subnam))
 ; Ŀ
 ;   See if the (partial-p) block name was present in the search list.     
 ; 
 (member blnam blist))
 ; Ŀ
 ;   Subroutine Xnam end.                                                  
 ; 

 ; Ŀ
 ;   Bomex.                                                                
 ; 
 (DEFUN C:BOMEX (/ blist blnam *error* ss num enam elist lista filnam namf
                                                                      exlist)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq blist (list "matltag" "bomtag" "bomtag2"))
  (setq blnam "matltag,bomtag,bomtag2")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if (/= shk "Function cancelled") (write-line shk))
   (command ".undo" "end")
  (princ))
 ; Ŀ
 ;   Mention if there are blocks in different spaces.                      
 ; 
  (if (> (length (wisp blnam)) 1)
      (prompt "* Caution: Bom blocks located in more than one space. *"))
 ; Ŀ
 ;   Get an ss of all material tag block insertions.                       
 ; 
  (setq ss (ssget "x" (list '(-4 . "<and") '(0 . "insert") '(66 . 1)
                                            (cons 2 blnam)
                            '(-4 . "and>"))))
 ; Ŀ
 ;   Make the ss into a list of enames.                                    
 ; 
   (setq num 0)
   (while (setq enam (ssname ss num))
          (setq elist (cons enam elist))
          (setq num (1+ num)))
 ; Ŀ
 ;   Call Pomp to get a list of enames of bom block insertions which are   
 ;   subentities of other blocks.                                          
 ; 
  (setq lista (pomp blist))
  (setq elist (append elist lista))
 ; Ŀ
 ;   Call Bomp to extract the attribute values from each bom block into a  
 ;   list of lists.                                                        
 ;   Lista is passed as a separate argument so that enames therein won't   
 ;   be arked - their locations are not absolute but offsets in their      
 ;   parent blocks.                                                        
 ; 
 (if (not (setq lista (bomp elist lista)))
      (write-line "No Bom blocks found.")
      (progn
           (setq filnam (strcat (getvar "dwgprefix") "Bom.csv"))
 ; Ŀ
 ;   If the file exists, read it into its own list.                        
 ; 
           (if (setq namf (findfile filnam))
               (progn
                    (setq exlist (cdfout namf))
 ; Ŀ
 ;   Combine the file list and the drawing list.                           
 ; 
                    (setq lista (combix lista exlist))))
 ; Ŀ
 ;   Sort the list by first number.                                        
 ; 
           (setq lista (horiz lista))
 ; Ŀ
 ;   Write the list to the csv file.                                       
 ; 
           (bullax lista filnam)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
   (command ".undo" "end")
 (princ))